//  Copyright (C) 2000 VMELinux Project and Michael Wyrick
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  
//---------------------------------------------------------------------------
//title: VME Debugger for XVME-655 
//---------------------------------------------------------------------------  
//  Purpose:                                                                    
//  Docs:                                                                       
//---------------------------------------------------------------------------  
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#include "unilib.h"
#include "universe.h"
#include "commands.h"
#include "vmeutils.h"

char buffer[255];
char oldbuffer[255];
int  bufpointer = 0;
int  oldbufpointer = 0;

// Command Line Registers
int  quiet = 0;
int  verb_para = 1;
int  which_img = 0;
int  default_mode = 1;	 
int  binary       = 0;

/*-----------------------------------------------------------------------------
 *
 *
 *------------------------------------------------------------------------mjw-*/
void initvme(void)
{
}

/*-----------------------------------------------------------------------------
 * addchar 
 *   add a char to the command buffer and check to see if we have the whole
 *   buffer (if the char is a return)
 *------------------------------------------------------------------------mjw-*/
void addchar(char c)
{
  int x;
//  if (c == 0x08) {                         // Back Space
//    if (bufpointer != 0) {
//      bufpointer--;
//      if (!quiet)
//        printf("%c",c);
//      if (!quiet)
//        printf(" ");
//      if (!quiet)
//        printf("%c",c);
//    }
// } else if (c == 0x48) {                  // We have gotten the entire command
//   memcpy(buffer,oldbuffer,sizeof(buffer));
//   bufpointer = oldbufpointer;            // Clear Buffer Pointer
//   if (!quiet)
//     printf("%s",buffer);
// } else if (c == 0x50) {                  // We have gotten the entire command
//   if (!quiet)
//     for(x=0;x<bufpointer;x++)
//       printf("%c %c",0x08,0x08);           // print BackSpace
//   bufpointer = 0;
//  } else if (c != 0x0A) {                  // We have gotten the entire command
  if (c != 0x0A) {                  // We have gotten the entire command
    buffer[bufpointer++] = toupper(c);
//    printf("%c",c);
  } else  {
    buffer[bufpointer] = 0;                // Null Term the String
    memcpy(oldbuffer,buffer,sizeof(buffer));
    oldbufpointer = bufpointer;            // Clear Buffer Pointer
    if(!quiet)
      printf("\n");
    ProcessCommand(buffer,bufpointer);
    bufpointer = 0;                        // Clear Buffer Pointer
    if (!quiet)
      printf("\n> ");
  }
}

/*-----------------------------------------------------------------------------
 *  
 *
 *------------------------------------------------------------------------mjw-*/
void readprompt(void)
{
  int i;
  
  while(1) {
    i = getchar();
    if (i > 0) {
      addchar(char(i & 0xFF));
    }
  }
}

/*-----------------------------------------------------------------------------
 *  ParseCmdLine
 *
 *------------------------------------------------------------------------mjw-*/
int ParseCmdLine(int argc,char **argv)
{ 
  int i,j;       
  char *p,c;
  
  if (argc == 1)
    return(1);	 
  
  for(i=0;i<argc;i++) {
    p = argv[i];
    if (p[0] == '-') {
      j = 1;
      while(c = p[j++]) {
        switch(c) {	
          case 'V' :
  	    verb_para = 0;
            printf("VMEUtils Verbose Parameters Mode on\n");
    	    break;
          case 'v' :
  	    verb_para = 1;
	    if (!verb_para)
	      printf("  Verbose Parameters Mode off\n");
    	    break;
          case 'q' :
  	    quiet = 1;
	    if (!verb_para)
	      printf("  Quiet Mode\n");
    	    break;
          case 'Q' :
	    quiet = 0;
	    if (!verb_para)
	      printf("  Non Quiet Mode\n");
	    break;
          case 'b' :
  	    binary = 0;
	    if (!verb_para)
	      printf("  Binary Mode off\n");
    	    break;
          case 'B' :
	    binary = 1;
	    if (!verb_para)
	      printf("  Binary Mode on\n");
	    break;
	  case 'D' :
	  case 'd' :
	    default_mode = MODE_DMA;
	    if (!verb_para)
	      printf("  Default mode Changed to DMA\n");
	    break;  	   
	  case 'P' :
	  case 'p' :
	    default_mode = MODE_PROGRAMMED;
	    if (!verb_para)
	      printf("  Default mode Changed to PROGRAMMED\n");
	    break;  	    
     	  case '0' :
	    which_img = 0;
	    if (!verb_para)
	      printf("  Image Changed to 0\n");
	    break;
	  case '1' :
	    which_img = 1;
	    if (!verb_para)
	      printf("  Image Changed to 1\n");
	    break;
	  case '2' :
	    which_img = 2;
	    if (!verb_para)
	      printf("  Image Changed to 2\n");
	    break;
	  case '3' :
	    which_img = 3;
	    if (!verb_para)
	      printf("  Image Changed to 3\n");
	    break;
        }	    
      }
    }
  }    
}

/*-----------------------------------------------------------------------------
 *  main
 *
 *------------------------------------------------------------------------mjw-*/
void main(int argc,char **argv)
{ 
  ParseCmdLine(argc,argv);

  if (!quiet) {
    printf("\nVME Debugger Linux Version 0.9b 990330\n");
    printf("Copyright 1998, Michael J. Wyrick, VMELinux Project\n");

    printf("> ");
  } 
  
  init_vmelib();
  readprompt();
}
